using System;
using SPECIMENTESTTHRESHOLD = gov.va.med.vbecs.Common.VbecsTables.SpecimenTestThreshold;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for SpecimenTestThreshold.
	/// </summary>
	public class SpecimenTestThreshold : BaseBusinessObject 
	{

		#region Constructors

		private System.Data.DataRow _drThreshold;
		private System.Data.DataTable _dtThreshold;

		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3605"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>SpecimenTestThreshold object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3606"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SpecimenTestThreshold
		/// </summary>
		public SpecimenTestThreshold(System.Data.DataRow dtRow)
		{
			this._dtThreshold = this.GetEmptySpecimentThresholdResultTable();
			this._drThreshold = this._dtThreshold.NewRow();
			this.LoadFromDataRow(dtRow);
		}

		#endregion


		#region Properties

				
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3607"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3616"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SpecimenTestThresholdGuid
		/// </summary>
		public System.Guid SpecimenTestThresholdGuid
		{
			get
			{
				return (System.Guid)this._drThreshold[SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid];
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3617"> 
		///		<ExpectedInput>Int</ExpectedInput>
		///		<ExpectedOutput>Int</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3620"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ComponentClassId
		/// </summary>
		public int ComponentClassId
		{
			get
			{
				return (int)this._drThreshold[SPECIMENTESTTHRESHOLD.ComponentClassId];
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.ComponentClassId] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3621"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3713"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// VistaLaboratoryTestName
		/// </summary>
		public string VistaLaboratoryTestName
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3714"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3715"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SpecimenTypeCode
		/// </summary>
		public string SpecimenTypeCode
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.SpecimenTypeCode].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.SpecimenTypeCode] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3716"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3717"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// LabTestId
		/// </summary>
		public string LabTestId
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.LabTestId].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.LabTestId] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3722"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3723"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// WorkloadCode
		/// </summary>
		public string WorkloadCode
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.WorkloadCode].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.WorkloadCode] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3730"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3731"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ThresholdResult
		/// </summary>
		public string ThresholdResult
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.ThresholdResult].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.ThresholdResult] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3734"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3735"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReportTypeId
		/// </summary>
		public int ReportTypeId
		{
			get
			{
				return (int)this._drThreshold[SPECIMENTESTTHRESHOLD.ReportTypeId];
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.ReportTypeId] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3778"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3779"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DivisionCode
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.DivisionCode].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.DivisionCode] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3791"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3899"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RecordStatusCode
		/// </summary>
		public string RecordStatusCode
		{
			get
			{
				return this._drThreshold[SPECIMENTESTTHRESHOLD.RecordStatusCode].ToString();
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.RecordStatusCode] = value;
			}
		}

		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3900"> 
		///		<ExpectedInput>byte[]</ExpectedInput>
		///		<ExpectedOutput>byte[]</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3927"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RowVersion
		/// </summary>
		public new byte[] RowVersion
		{
			get
			{
				return (byte[])this._drThreshold[SPECIMENTESTTHRESHOLD.RowVersion];
			}
			set
			{
				this._drThreshold[SPECIMENTESTTHRESHOLD.RowVersion] = value;
			}
		}

		#endregion


		#region Methods




		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.ComponentClassId))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.ComponentClassId))
				{
					this.ComponentClassId = (int)dtRow[SPECIMENTESTTHRESHOLD.ComponentClassId];
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.DivisionCode))
			{
				if (dtRow.IsNull(SPECIMENTESTTHRESHOLD.DivisionCode))
				{
					this.DivisionCode = dtRow[SPECIMENTESTTHRESHOLD.DivisionCode].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.LabTestId))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.LabTestId))
				{
					this.LabTestId = dtRow[SPECIMENTESTTHRESHOLD.LabTestId].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.RecordStatusCode))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.RecordStatusCode))
				{
					this.RecordStatusCode = dtRow[SPECIMENTESTTHRESHOLD.RecordStatusCode].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.ReportTypeId))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.ReportTypeId))
				{
					this.ReportTypeId = (int)dtRow[SPECIMENTESTTHRESHOLD.ReportTypeId];
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.RowVersion))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.RowVersion))
				{
					this.RowVersion = (byte[])dtRow[SPECIMENTESTTHRESHOLD.RowVersion];
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid))
				{
					this.SpecimenTestThresholdGuid = (System.Guid)dtRow[SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.SpecimenTypeCode))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.SpecimenTypeCode))
				{
					this.SpecimenTypeCode = dtRow[SPECIMENTESTTHRESHOLD.SpecimenTypeCode].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.ThresholdResult))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.ThresholdResult))
				{
					this.ThresholdResult = dtRow[SPECIMENTESTTHRESHOLD.ThresholdResult].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName))
				{
					this.VistaLaboratoryTestName = dtRow[SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName].ToString();
				}
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.WorkloadCode))
			{
				if (!dtRow.IsNull(SPECIMENTESTTHRESHOLD.WorkloadCode))
				{
					this.WorkloadCode = dtRow[SPECIMENTESTTHRESHOLD.WorkloadCode].ToString();
				}
			}

		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3997"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3999"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.ComponentClassId))
			{
				dtRow[SPECIMENTESTTHRESHOLD.ComponentClassId] = this.ComponentClassId;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.DivisionCode))
			{
				dtRow[SPECIMENTESTTHRESHOLD.DivisionCode] = this.DivisionCode;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.LabTestId))
			{
				dtRow[SPECIMENTESTTHRESHOLD.LabTestId] = this.LabTestId;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.RecordStatusCode))
			{
				dtRow[SPECIMENTESTTHRESHOLD.RecordStatusCode] = this.RecordStatusCode;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.ReportTypeId))
			{
				dtRow[SPECIMENTESTTHRESHOLD.ReportTypeId] = this.ReportTypeId;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.RowVersion))
			{
				dtRow[SPECIMENTESTTHRESHOLD.RowVersion] = this.RowVersion;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid))
			{
				dtRow[SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid] = this.SpecimenTestThresholdGuid;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.SpecimenTypeCode))
			{
				dtRow[SPECIMENTESTTHRESHOLD.SpecimenTypeCode] = this.SpecimenTypeCode;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.ThresholdResult))
			{
				dtRow[SPECIMENTESTTHRESHOLD.ThresholdResult] = this.ThresholdResult;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName))
			{
				dtRow[SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName] = this.VistaLaboratoryTestName;
			}

			if (dtRow.Table.Columns.Contains(SPECIMENTESTTHRESHOLD.WorkloadCode))
			{
				dtRow[SPECIMENTESTTHRESHOLD.WorkloadCode] = this.WorkloadCode;
			}

			return(dtRow);
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4011"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="4015"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetEmptySpecimentThresholdResultTable
		/// </summary>
		/// <returns></returns>
		public System.Data.DataTable GetEmptySpecimentThresholdResultTable()
		{
			System.Data.DataTable dt = new System.Data.DataTable(SPECIMENTESTTHRESHOLD.TableName);

			dt.Columns.Add(SPECIMENTESTTHRESHOLD.ComponentClassId, typeof(int));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.DivisionCode , typeof(string));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.LabTestId, typeof(string));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.RecordStatusCode, typeof(string));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.ReportTypeId, typeof(int));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.RowVersion, typeof(byte[]));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.SpecimenTestThresholdGuid, typeof(System.Guid));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.SpecimenTypeCode, typeof(string));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.ThresholdResult, typeof(string));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.VistaLaboratoryTestName, typeof(string));
			dt.Columns.Add(SPECIMENTESTTHRESHOLD.WorkloadCode, typeof(string));

			return(dt);
		}
		#endregion

	}
}
